/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.jspecify.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeWin32 {
    protected GLFWNativeWin32() {
        throw new UnsupportedOperationException();
    }

    public static long nglfwGetWin32Adapter(long monitor) {
        long __functionAddress = Functions.GetWin32Adapter;
        if (Checks.CHECKS) {
            Checks.check((long)monitor);
        }
        return JNI.invokePP((long)monitor, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String glfwGetWin32Adapter(@NativeType(value="GLFWmonitor *") long monitor) {
        long __result = GLFWNativeWin32.nglfwGetWin32Adapter(monitor);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nglfwGetWin32Monitor(long monitor) {
        long __functionAddress = Functions.GetWin32Monitor;
        if (Checks.CHECKS) {
            Checks.check((long)monitor);
        }
        return JNI.invokePP((long)monitor, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String glfwGetWin32Monitor(@NativeType(value="GLFWmonitor *") long monitor) {
        long __result = GLFWNativeWin32.nglfwGetWin32Monitor(monitor);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="HWND")
    public static long glfwGetWin32Window(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetWin32Window;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="GLFWwindow *")
    public static long glfwAttachWin32Window(@NativeType(value="HWND") long handle, @NativeType(value="GLFWwindow *") long share) {
        long __functionAddress = Functions.AttachWin32Window;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)handle);
        }
        return JNI.invokePPP((long)handle, (long)share, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetWin32Adapter = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetWin32Adapter");
        public static final long GetWin32Monitor = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetWin32Monitor");
        public static final long GetWin32Window = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetWin32Window");
        public static final long AttachWin32Window = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)GLFW.getLibrary(), (String)"glfwAttachWin32Window");

        private Functions() {
        }
    }
}

