/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct GLFWimage")
public class GLFWImage
extends Struct<GLFWImage>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int PIXELS;

    protected GLFWImage(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected GLFWImage create(long address, @Nullable ByteBuffer container) {
        return new GLFWImage(address, container);
    }

    public GLFWImage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), GLFWImage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return GLFWImage.nwidth(this.address());
    }

    public int height() {
        return GLFWImage.nheight(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer pixels(int capacity) {
        return GLFWImage.npixels(this.address(), capacity);
    }

    public GLFWImage width(int value) {
        GLFWImage.nwidth(this.address(), value);
        return this;
    }

    public GLFWImage height(int value) {
        GLFWImage.nheight(this.address(), value);
        return this;
    }

    public GLFWImage pixels(@NativeType(value="unsigned char *") ByteBuffer value) {
        GLFWImage.npixels(this.address(), value);
        return this;
    }

    public GLFWImage set(int width, int height, ByteBuffer pixels) {
        this.width(width);
        this.height(height);
        this.pixels(pixels);
        return this;
    }

    public GLFWImage set(GLFWImage src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static GLFWImage malloc() {
        return new GLFWImage(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static GLFWImage calloc() {
        return new GLFWImage(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static GLFWImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new GLFWImage(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static GLFWImage create(long address) {
        return new GLFWImage(address, null);
    }

    public static @Nullable GLFWImage createSafe(long address) {
        return address == 0L ? null : new GLFWImage(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)GLFWImage.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = GLFWImage.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static GLFWImage malloc(MemoryStack stack) {
        return new GLFWImage(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static GLFWImage calloc(MemoryStack stack) {
        return new GLFWImage(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static ByteBuffer npixels(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)), (int)capacity);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WIDTH), (int)value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEIGHT), (int)value);
    }

    public static void npixels(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXELS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)));
    }

    static {
        Struct.Layout layout = GLFWImage.__struct((Struct.Member[])new Struct.Member[]{GLFWImage.__member((int)4), GLFWImage.__member((int)4), GLFWImage.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        PIXELS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<GLFWImage, Buffer>
    implements NativeResource {
        private static final GLFWImage ELEMENT_FACTORY = GLFWImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected GLFWImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int width() {
            return GLFWImage.nwidth(this.address());
        }

        public int height() {
            return GLFWImage.nheight(this.address());
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer pixels(int capacity) {
            return GLFWImage.npixels(this.address(), capacity);
        }

        public Buffer width(int value) {
            GLFWImage.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            GLFWImage.nheight(this.address(), value);
            return this;
        }

        public Buffer pixels(@NativeType(value="unsigned char *") ByteBuffer value) {
            GLFWImage.npixels(this.address(), value);
            return this;
        }
    }
}

