/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FT_BBox
extends Struct<FT_BBox>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XMIN;
    public static final int YMIN;
    public static final int XMAX;
    public static final int YMAX;

    protected FT_BBox(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_BBox create(long address, @Nullable ByteBuffer container) {
        return new FT_BBox(address, container);
    }

    public FT_BBox(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_BBox.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_Pos")
    public long xMin() {
        return FT_BBox.nxMin(this.address());
    }

    @NativeType(value="FT_Pos")
    public long yMin() {
        return FT_BBox.nyMin(this.address());
    }

    @NativeType(value="FT_Pos")
    public long xMax() {
        return FT_BBox.nxMax(this.address());
    }

    @NativeType(value="FT_Pos")
    public long yMax() {
        return FT_BBox.nyMax(this.address());
    }

    public FT_BBox xMin(@NativeType(value="FT_Pos") long value) {
        FT_BBox.nxMin(this.address(), value);
        return this;
    }

    public FT_BBox yMin(@NativeType(value="FT_Pos") long value) {
        FT_BBox.nyMin(this.address(), value);
        return this;
    }

    public FT_BBox xMax(@NativeType(value="FT_Pos") long value) {
        FT_BBox.nxMax(this.address(), value);
        return this;
    }

    public FT_BBox yMax(@NativeType(value="FT_Pos") long value) {
        FT_BBox.nyMax(this.address(), value);
        return this;
    }

    public FT_BBox set(long xMin, long yMin, long xMax, long yMax) {
        this.xMin(xMin);
        this.yMin(yMin);
        this.xMax(xMax);
        this.yMax(yMax);
        return this;
    }

    public FT_BBox set(FT_BBox src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FT_BBox malloc() {
        return new FT_BBox(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FT_BBox calloc() {
        return new FT_BBox(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FT_BBox create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FT_BBox(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FT_BBox create(long address) {
        return new FT_BBox(address, null);
    }

    public static @Nullable FT_BBox createSafe(long address) {
        return address == 0L ? null : new FT_BBox(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FT_BBox.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FT_BBox.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FT_BBox malloc(MemoryStack stack) {
        return new FT_BBox(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FT_BBox calloc(MemoryStack stack) {
        return new FT_BBox(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nxMin(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)XMIN));
    }

    public static long nyMin(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)YMIN));
    }

    public static long nxMax(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)XMAX));
    }

    public static long nyMax(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)YMAX));
    }

    public static void nxMin(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)XMIN), (long)value);
    }

    public static void nyMin(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)YMIN), (long)value);
    }

    public static void nxMax(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)XMAX), (long)value);
    }

    public static void nyMax(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)YMAX), (long)value);
    }

    static {
        Struct.Layout layout = FT_BBox.__struct((Struct.Member[])new Struct.Member[]{FT_BBox.__member((int)CLONG_SIZE), FT_BBox.__member((int)CLONG_SIZE), FT_BBox.__member((int)CLONG_SIZE), FT_BBox.__member((int)CLONG_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XMIN = layout.offsetof(0);
        YMIN = layout.offsetof(1);
        XMAX = layout.offsetof(2);
        YMAX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<FT_BBox, Buffer>
    implements NativeResource {
        private static final FT_BBox ELEMENT_FACTORY = FT_BBox.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FT_BBox getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_Pos")
        public long xMin() {
            return FT_BBox.nxMin(this.address());
        }

        @NativeType(value="FT_Pos")
        public long yMin() {
            return FT_BBox.nyMin(this.address());
        }

        @NativeType(value="FT_Pos")
        public long xMax() {
            return FT_BBox.nxMax(this.address());
        }

        @NativeType(value="FT_Pos")
        public long yMax() {
            return FT_BBox.nyMax(this.address());
        }

        public Buffer xMin(@NativeType(value="FT_Pos") long value) {
            FT_BBox.nxMin(this.address(), value);
            return this;
        }

        public Buffer yMin(@NativeType(value="FT_Pos") long value) {
            FT_BBox.nyMin(this.address(), value);
            return this;
        }

        public Buffer xMax(@NativeType(value="FT_Pos") long value) {
            FT_BBox.nxMax(this.address(), value);
            return this;
        }

        public Buffer yMax(@NativeType(value="FT_Pos") long value) {
            FT_BBox.nyMax(this.address(), value);
            return this;
        }
    }
}

