/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class JavaOps
implements DynamicOps<Object> {
    public static final JavaOps INSTANCE = new JavaOps();

    private JavaOps() {
    }

    @Override
    public Object empty() {
        return null;
    }

    @Override
    public Object emptyMap() {
        return Map.of();
    }

    @Override
    public Object emptyList() {
        return List.of();
    }

    @Override
    public <U> U convertTo(DynamicOps<U> outOps, Object input) {
        if (input == null) {
            return outOps.empty();
        }
        if (input instanceof Map) {
            return this.convertMap(outOps, input);
        }
        if (input instanceof ByteList) {
            ByteList value = (ByteList)input;
            return outOps.createByteList(ByteBuffer.wrap(value.toByteArray()));
        }
        if (input instanceof IntList) {
            IntList value = (IntList)input;
            return outOps.createIntList(value.intStream());
        }
        if (input instanceof LongList) {
            LongList value = (LongList)input;
            return outOps.createLongList(value.longStream());
        }
        if (input instanceof List) {
            return this.convertList(outOps, input);
        }
        if (input instanceof String) {
            String value = (String)input;
            return outOps.createString(value);
        }
        if (input instanceof Boolean) {
            Boolean value = (Boolean)input;
            return outOps.createBoolean(value);
        }
        if (input instanceof Byte) {
            Byte value = (Byte)input;
            return outOps.createByte(value);
        }
        if (input instanceof Short) {
            Short value = (Short)input;
            return outOps.createShort(value);
        }
        if (input instanceof Integer) {
            Integer value = (Integer)input;
            return outOps.createInt(value);
        }
        if (input instanceof Long) {
            Long value = (Long)input;
            return outOps.createLong(value);
        }
        if (input instanceof Float) {
            Float value = (Float)input;
            return outOps.createFloat(value.floatValue());
        }
        if (input instanceof Double) {
            Double value = (Double)input;
            return outOps.createDouble(value);
        }
        if (input instanceof Number) {
            Number value = (Number)input;
            return outOps.createNumeric(value);
        }
        throw new IllegalStateException("Don't know how to convert " + String.valueOf(input));
    }

    @Override
    public DataResult<Number> getNumberValue(Object input) {
        if (input instanceof Number) {
            Number value = (Number)input;
            return DataResult.success(value);
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    @Override
    public Object createNumeric(Number value) {
        return value;
    }

    @Override
    public Object createByte(byte value) {
        return value;
    }

    @Override
    public Object createShort(short value) {
        return value;
    }

    @Override
    public Object createInt(int value) {
        return value;
    }

    @Override
    public Object createLong(long value) {
        return value;
    }

    @Override
    public Object createFloat(float value) {
        return Float.valueOf(value);
    }

    @Override
    public Object createDouble(double value) {
        return value;
    }

    @Override
    public DataResult<Boolean> getBooleanValue(Object input) {
        if (input instanceof Boolean) {
            Boolean value = (Boolean)input;
            return DataResult.success(value);
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    @Override
    public Object createBoolean(boolean value) {
        return value;
    }

    @Override
    public DataResult<String> getStringValue(Object input) {
        if (input instanceof String) {
            String value = (String)input;
            return DataResult.success(value);
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    @Override
    public Object createString(String value) {
        return value;
    }

    @Override
    public DataResult<Object> mergeToList(Object input, Object value) {
        if (input == this.empty()) {
            return DataResult.success(List.of(value));
        }
        if (input instanceof List) {
            List list = (List)input;
            if (list.isEmpty()) {
                return DataResult.success(List.of(value));
            }
            return DataResult.success(ImmutableList.builder().addAll((Iterable)list).add(value).build());
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(input));
    }

    @Override
    public DataResult<Object> mergeToList(Object input, List<Object> values) {
        if (input == this.empty()) {
            return DataResult.success(values);
        }
        if (input instanceof List) {
            List list = (List)input;
            if (list.isEmpty()) {
                return DataResult.success(values);
            }
            return DataResult.success(ImmutableList.builder().addAll((Iterable)list).addAll(values).build());
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(input));
    }

    @Override
    public DataResult<Object> mergeToMap(Object input, Object key, Object value) {
        if (input == this.empty()) {
            return DataResult.success(Map.of(key, value));
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (map.isEmpty()) {
                return DataResult.success(Map.of(key, value));
            }
            ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)(map.size() + 1));
            result.putAll(map);
            result.put(key, value);
            return DataResult.success(result.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    @Override
    public DataResult<Object> mergeToMap(Object input, Map<Object, Object> values) {
        if (input == this.empty()) {
            return DataResult.success(values);
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (map.isEmpty()) {
                return DataResult.success(values);
            }
            ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)(map.size() + values.size()));
            result.putAll(map);
            result.putAll(values);
            return DataResult.success(result.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    private static Map<Object, Object> mapLikeToMap(MapLike<Object> values) {
        return (Map)values.entries().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    public DataResult<Object> mergeToMap(Object input, MapLike<Object> values) {
        if (input == this.empty()) {
            return DataResult.success(JavaOps.mapLikeToMap(values));
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (map.isEmpty()) {
                return DataResult.success(JavaOps.mapLikeToMap(values));
            }
            ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)map.size());
            result.putAll(map);
            values.entries().forEach(e -> result.put(e.getFirst(), e.getSecond()));
            return DataResult.success(result.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    private static Stream<Pair<Object, Object>> getMapEntries(Map<?, ?> input) {
        return input.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue()));
    }

    @Override
    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
        if (input instanceof Map) {
            Map map = (Map)input;
            return DataResult.success(JavaOps.getMapEntries(map));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    @Override
    public DataResult<Consumer<BiConsumer<Object, Object>>> getMapEntries(Object input) {
        if (input instanceof Map) {
            Map map = (Map)input;
            return DataResult.success(map::forEach);
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    @Override
    public Object createMap(Stream<Pair<Object, Object>> map) {
        return map.collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    public DataResult<MapLike<Object>> getMap(Object input) {
        if (input instanceof Map) {
            final Map map = (Map)input;
            return DataResult.success(new MapLike<Object>(){

                @Override
                @Nullable
                public Object get(Object key) {
                    return map.get(key);
                }

                @Override
                @Nullable
                public Object get(String key) {
                    return map.get(key);
                }

                @Override
                public Stream<Pair<Object, Object>> entries() {
                    return JavaOps.getMapEntries(map);
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(map) + "]";
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    @Override
    public Object createMap(Map<Object, Object> map) {
        return map;
    }

    @Override
    public DataResult<Stream<Object>> getStream(Object input) {
        if (input instanceof List) {
            List list = (List)input;
            return DataResult.success(list.stream().map(o -> o));
        }
        return DataResult.error(() -> "Not an list: " + String.valueOf(input));
    }

    @Override
    public DataResult<Consumer<Consumer<Object>>> getList(Object input) {
        if (input instanceof List) {
            List list = (List)input;
            return DataResult.success(list::forEach);
        }
        return DataResult.error(() -> "Not an list: " + String.valueOf(input));
    }

    @Override
    public Object createList(Stream<Object> input) {
        return input.toList();
    }

    @Override
    public DataResult<ByteBuffer> getByteBuffer(Object input) {
        if (input instanceof ByteList) {
            ByteList value = (ByteList)input;
            return DataResult.success(ByteBuffer.wrap(value.toByteArray()));
        }
        return DataResult.error(() -> "Not a byte list: " + String.valueOf(input));
    }

    @Override
    public Object createByteList(ByteBuffer input) {
        ByteBuffer wholeBuffer = input.duplicate().clear();
        ByteArrayList result = new ByteArrayList();
        result.size(wholeBuffer.capacity());
        wholeBuffer.get(0, result.elements(), 0, result.size());
        return result;
    }

    @Override
    public DataResult<IntStream> getIntStream(Object input) {
        if (input instanceof IntList) {
            IntList value = (IntList)input;
            return DataResult.success(value.intStream());
        }
        return DataResult.error(() -> "Not an int list: " + String.valueOf(input));
    }

    @Override
    public Object createIntList(IntStream input) {
        return IntArrayList.toList((IntStream)input);
    }

    @Override
    public DataResult<LongStream> getLongStream(Object input) {
        if (input instanceof LongList) {
            LongList value = (LongList)input;
            return DataResult.success(value.longStream());
        }
        return DataResult.error(() -> "Not a long list: " + String.valueOf(input));
    }

    @Override
    public Object createLongList(LongStream input) {
        return LongArrayList.toList((LongStream)input);
    }

    @Override
    public Object remove(Object input, String key) {
        if (input instanceof Map) {
            Map map = (Map)input;
            LinkedHashMap result = new LinkedHashMap(map);
            result.remove(key);
            return Map.copyOf(result);
        }
        return input;
    }

    @Override
    public RecordBuilder<Object> mapBuilder() {
        return new FixedMapBuilder<Object>(this);
    }

    public String toString() {
        return "Java";
    }

    private static final class FixedMapBuilder<T>
    extends RecordBuilder.AbstractUniversalBuilder<T, ImmutableMap.Builder<T, T>> {
        public FixedMapBuilder(DynamicOps<T> ops) {
            super(ops);
        }

        @Override
        protected ImmutableMap.Builder<T, T> initBuilder() {
            return ImmutableMap.builder();
        }

        @Override
        protected ImmutableMap.Builder<T, T> append(T key, T value, ImmutableMap.Builder<T, T> builder) {
            return builder.put(key, value);
        }

        @Override
        protected DataResult<T> build(ImmutableMap.Builder<T, T> builder, T prefix) {
            ImmutableMap result = builder.buildKeepingLast();
            return this.ops().mergeToMap(prefix, (Map<T, T>)result);
        }
    }
}

